import { useAppearance } from '@/hooks/use-appearance';
import { cn } from '@/lib/utils';

const layouts = [
    { value: 'sidebar', label: 'Sidebar' },
    { value: 'header', label: 'Header' },
] as const;

export default function AppLayoutTabs() {
    const { appLayout, updateAppLayout } = useAppearance();

    return (
        <div>
            <p className="mb-2 text-sm font-medium text-muted-foreground">App Page Layout</p>
            <div className="inline-flex gap-1 rounded-lg border border-border bg-card p-1 shadow-sm transition-colors">
                {layouts.map(({ value, label }) => (
                    <button
                        key={value}
                        onClick={() => updateAppLayout(value)}
                        className={cn(
                            'rounded-md px-3.5 py-1.5 text-sm font-medium transition-colors',
                            appLayout === value
                                ? 'bg-accent text-accent-foreground shadow-sm'
                                : 'text-muted-foreground hover:bg-muted hover:text-foreground'
                        )}
                    >
                        {label}
                    </button>
                ))}
            </div>
        </div>
    );
}
