import { Appearance, useAppearance } from '@/hooks/use-appearance'
import { cn } from '@/lib/utils'
import { LucideIcon, Monitor, Moon, Sun } from 'lucide-react'
import { HTMLAttributes, useEffect } from 'react'

export default function AppearanceToggleTab({
  className = '',
  ...props
}: HTMLAttributes<HTMLDivElement>) {
  const { appearance, updateAppearance } = useAppearance()

  const tabs: { value: Appearance; icon: LucideIcon; label: string }[] = [
    { value: 'light', icon: Sun, label: 'Light' },
    { value: 'dark', icon: Moon, label: 'Dark' },
    { value: 'system', icon: Monitor, label: 'System' },
  ]

  // 🌙 Set default ke dark saat pertama kali render
  useEffect(() => {
    if (!appearance) updateAppearance('dark')
  }, [appearance, updateAppearance])

  return (
    <div
      className={cn(
        'inline-flex gap-1 rounded-lg border border-border bg-card p-1 shadow-sm transition-colors',
        className
      )}
      {...props}
    >
      {tabs.map(({ value, icon: Icon, label }) => (
        <button
          key={value}
          onClick={() => updateAppearance(value)}
          className={cn(
            'flex items-center rounded-md px-3.5 py-1.5 text-sm font-medium transition-colors',
            appearance === value
              ? 'bg-accent text-accent-foreground shadow-sm'
              : 'text-muted-foreground hover:bg-muted hover:text-foreground'
          )}
        >
          <Icon className="mr-1.5 h-4 w-4" />
          {label}
        </button>
      ))}
    </div>
  )
}
