import { Breadcrumbs } from '@/components/breadcrumbs';
import { QuickActions } from "@/components/quick-actions";
import { SidebarTrigger } from '@/components/ui/sidebar';
import { type BreadcrumbItem as BreadcrumbItemType } from '@/types';

export function AppSidebarHeader({ breadcrumbs = [] }: { breadcrumbs?: BreadcrumbItemType[] }) {
    return (
        <>
            {/* Header Utama */}
            <header className="border-sidebar-border/50 flex h-16 shrink-0 items-center justify-between gap-2 border-b px-6 transition-[width,height] ease-linear group-has-data-[collapsible=icon]/sidebar-wrapper:h-12 md:px-4 bg-sidebar">
                <div className="flex items-center gap-2">
                    <SidebarTrigger className="-ml-1" />
                    
                    {/* Breadcrumbs tampil hanya di desktop */}
                    <div className="hidden md:block">
                        <Breadcrumbs breadcrumbs={breadcrumbs} />
                    </div>
                </div>
                <QuickActions />
            </header>

            {/* Breadcrumbs tampil hanya di mobile */}
            <div className="block border-b border-sidebar-border/50 px-6 py-2 md:hidden">
                <Breadcrumbs breadcrumbs={breadcrumbs} />
            </div>
        </>
    );
}
