// Versi cache, ganti kalau update file
const CACHE_NAME = "kaspos-cache-v3";

// Halaman utama + asset penting yang ingin dicache
const urlsToCache = [
  "/",
  "/manifest.json",
  "/favicon.ico",
  "/css/app.css",
  "/js/app.js",
  // Rute utama POS
  "/dashboard",
  "/pos",
  "/kitchen",
  "/settings",
  "/backup",
  "/barcode-settings",
];

// Install service worker & cache asset
self.addEventListener("install", (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      return cache.addAll(urlsToCache);
    })
  );
});

// Fetch: ambil dari cache dulu, kalau tidak ada baru fetch server
self.addEventListener("fetch", (event) => {
  event.respondWith(
    caches.match(event.request).then((response) => {
      // Kalau ada di cache → kembalikan dari cache
      if (response) {
        return response;
      }
      // Kalau tidak ada → fetch ke server
      return fetch(event.request).catch(() => {
        // Kalau request gagal (offline) → fallback ke halaman utama
        if (event.request.mode === "navigate") {
          return caches.match("/");
        }
      });
    })
  );
});

// Aktivasi service worker baru & hapus cache lama
self.addEventListener("activate", (event) => {
  event.waitUntil(
    caches.keys().then((cacheNames) => {
      return Promise.all(
        cacheNames
          .filter((name) => name !== CACHE_NAME)
          .map((name) => caches.delete(name))
      );
    })
  );
});
